local assets=
{
	Asset("ANIM", "anim/enchantedmatter.zip"),
	Asset("IMAGE", "images/enchantedmatter.tex"),
	Asset("ATLAS", "images/enchantedmatter.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("enchantedmatter")
    inst.AnimState:SetBuild("enchantedmatter")
    inst.AnimState:PlayAnimation("idle",true)
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    

	--inst:AddComponent("tradable")    
	--inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT*2
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "enchantedmatter"
    inst.components.inventoryitem.atlasname = "images/enchantedmatter.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "HORRIBLE"
    

    return inst
end

return 	Prefab( "common/inventory/enchantedmatter", fn, assets)